/////////////////////////////////////////////////////////////////////////////
// RecordDlg.cpp : FileDialog zur Auswahl von Samplingraten
// (C) Copyright G DATA Software AG 1992-2001

#include "stdafx.h"
#include "LogoxApp.h"
#include "RecordDlg.h"
#include "Lgx4.h"

/////////////////////////////////////////////////////////////////////////////

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CRecordFileDlg
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

char CRecordFileDlg::m_szFormat[NFORMAT][24] =
{
	"8kHz, 8Bit, mono",
	"8kHz, 8Bit, stereo",
	"8kHz, 16bit, mono",
	"8kHz, 16Bit, stereo",
	"11kHz, 8Bit, mono",
	"11kHz, 8Bit, stereo",
	"11kHz, 16bit, mono",
	"11kHz, 16Bit, stereo",
	"12kHz, 8Bit, mono",
	"12kHz, 8Bit, stereo",
	"12kHz, 16bit, mono",
	"12kHz, 16Bit, stereo",
	"16kHz, 8Bit, mono",
	"16kHz, 8Bit, stereo",
	"16kHz, 16bit, mono",
	"16kHz, 16Bit, stereo",
	"22kHz, 8Bit, mono",
	"22kHz, 8Bit, stereo",
	"22kHz, 16bit, mono",
	"22kHz, 16Bit, stereo",
	"24kHz, 8Bit, mono",
	"24kHz, 8Bit, stereo",
	"24kHz, 16bit, mono",
	"24kHz, 16Bit, stereo",
	"32kHz, 8Bit, mono",
	"32kHz, 8Bit, stereo",
	"32kHz, 16bit, mono",
	"32kHz, 16Bit, stereo",
	"44kHz, 8Bit, mono",
	"44kHz, 8Bit, stereo",
	"44kHz, 16bit, mono",
	"44kHz, 16Bit, stereo",
	"48kHz, 8Bit, mono",
	"48kHz, 8Bit, stereo",
	"48kHz, 16bit, mono",
	"48kHz, 16Bit, stereo",
};

unsigned long CRecordFileDlg::m_ulFormat[NFORMAT] =
{
	LOGOX_8kHz8BitMono,          
	LOGOX_8kHz8BitStereo,        
	LOGOX_8kHz16BitMono,         
	LOGOX_8kHz16BitStereo,       
	LOGOX_11kHz8BitMono,         
	LOGOX_11kHz8BitStereo,       
	LOGOX_11kHz16BitMono,        
	LOGOX_11kHz16BitStereo,      
	LOGOX_12kHz8BitMono,	     
	LOGOX_12kHz8BitStereo,       
	LOGOX_12kHz16BitMono,        
	LOGOX_12kHz16BitStereo,      
	LOGOX_16kHz8BitMono,	     
	LOGOX_16kHz8BitStereo,       
	LOGOX_16kHz16BitMono,        
	LOGOX_16kHz16BitStereo,      
	LOGOX_22kHz8BitMono,	     
	LOGOX_22kHz8BitStereo,       
	LOGOX_22kHz16BitMono,        
	LOGOX_22kHz16BitStereo,      
	LOGOX_24kHz8BitMono,	     
	LOGOX_24kHz8BitStereo,       
	LOGOX_24kHz16BitMono,        
	LOGOX_24kHz16BitStereo,      
	LOGOX_32kHz8BitMono,	     
	LOGOX_32kHz8BitStereo,       
	LOGOX_32kHz16BitMono,        
	LOGOX_32kHz16BitStereo,      
	LOGOX_44kHz8BitMono,	     
	LOGOX_44kHz8BitStereo,       
	LOGOX_44kHz16BitMono,        
	LOGOX_44kHz16BitStereo,      
	LOGOX_48kHz8BitMono,	     
	LOGOX_48kHz8BitStereo,       
	LOGOX_48kHz16BitMono,        
	LOGOX_48kHz16BitStereo
};

/////////////////////////////////////////////////////////////////////////////
// CRecordFileDlg construction

#define OPTIONS OFN_HIDEREADONLY|OFN_PATHMUSTEXIST|OFN_EXPLORER|OFN_FILEMUSTEXIST|OFN_OVERWRITEPROMPT|OFN_ENABLETEMPLATE

IMPLEMENT_DYNAMIC(CRecordFileDlg, CFileDialog)

CRecordFileDlg::CRecordFileDlg(CWnd* pParentWnd) : 
 CFileDialog(FALSE,"*.wav","*.wav",OPTIONS,"Audio Dateien (*.wav)|*.wav|alle Dateien (*.*)|*.*||",pParentWnd)
{
   m_ofn.hInstance = AfxGetInstanceHandle();
   m_ofn.lpTemplateName = MAKEINTRESOURCE(IDD_RECORD_DIALOG);
   m_iFormat = DEFAULTFORMAT;
}

BEGIN_MESSAGE_MAP(CRecordFileDlg, CFileDialog)
	//{{AFX_MSG_MAP(CRecordFileDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// WM_INITDIALOG
BOOL CRecordFileDlg::OnInitDialog() 
{
	CFileDialog::OnInitDialog();

	m_pDropList=(CComboBox*)GetDlgItem(IDC_FORMAT);

	int i;
	for(i=0;i<NFORMAT;i++)
	{
		m_pDropList->AddString(m_szFormat[i]);
	}
	m_pDropList->SetCurSel(m_iFormat);
	
	return TRUE; 
}

/////////////////////////////////////////////////////////////////////////////
// WM_COMMAND::IDOK
BOOL CRecordFileDlg::OnFileNameOK()
{
   m_iFormat = m_pDropList->GetCurSel();
   return CFileDialog::OnFileNameOK();
}
